<?php
/* App::uses('Helper', 'View'); */
App::uses('AppHelper', 'View/Helper');

class CommonHelper extends AppHelper {

	public function GetArrayData($modelname, $field){		//'Delivery', 'DeliComName')
		$model = ClassRegistry::init($modelname);
		$fields = array($field);
		$conditions = array();
		$group = array($field);
		$orders = array($field);
		$data = $model->find('list', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($data);
		$i = 0;
		$ret = array();
		foreach ($data as $key => $value) {
			//debug($key);
			//debug($value);
			$ret[$i++] = $value;
		}
//debug($ret);
		return $ret;
	}

	public function GetLeaveRemainTime2($room, $check_id){
		$check = $this->GetCheckDT1($room, $check_id);
		if($check == array())
			return "該当データなし room=".$room." checkid=".$check_id;
			
		return date("Y-m-d H:i:s", strtotime($check['leave_remain_time']." minute", strtotime($check['up_date'])));
	}

	public function GetDrinkFreeTime2($room, $check_id){
		$check = $this->GetCheckDT1($room, $check_id);
//debug($check['drink_free_time']);
		if($check == array())
			return "";
//debug($check['drink_free_kind']);
		if($check['drink_free_kind'] == 0)
			return "";
//debug($check['drink_free_time']);
		return date("Y-m-d H:i:s", strtotime($check['drink_free_time']." minute", strtotime($check['up_date'])));
	}

	public function GetMember(){
		$model = ClassRegistry::init('Member');

		$conditions = array();	//'check_id'=>$this->_check_id
		$order = array('member_no' => 'ASC');	//ASC | DESC
		$data1 = $model->find('all', array('conditions' => $conditions, 'order' => $order));
		return $data1;
	}

	public function GetStatusName($status=0){
		if($status > 4)
			return false;

		$snames = array("清掃終了", "入室", "タイムオーバー", "退室", "清掃中");
		return $snames[$status];
	}

	public function IsImgExists($img, $s){
		$path1 = WWW_ROOT . str_replace($s, '', $img);
		if(strstr($path1, "?"))
			$path = substr($path1, 0, strpos($path1, "?"));
//debug($path);
		if(file_exists($path))
			return true;
		else
			return false;
	}

	public function convertToMin($time="01:10:20"){
		$tArry=explode(":",$time);
		$hour=$tArry[0]*60;//時間→分
		if(isset($tArry[2]))
			$secnd = round($tArry[2]/60,2);//秒→分　少数第2を丸めてる
		else
			$secnd = 0;
		$mins=$hour+$tArry[1]+$secnd;//分だけを足す
		return $mins;
	}

	public function convertToHoursMins($time){
		$format = '%02d:%02d';
    	if ($time < 1) {
    	    return;
    	}
    	$hours = floor($time / 60);
    	$minutes = ($time % 60);
    	return sprintf($format, $hours, $minutes);
	}


	public function GetStaffName($id){
		$model = ClassRegistry::init('Staff');
		return $model->field('name', array('id'=>$id));
	}

	public function GetRoomName($id){
		$model = ClassRegistry::init('RoomInfo');
		return $model->field('RoomName', array('RoomID'=>$id));
	}

	public function GetMemberName($ids){
		$model = ClassRegistry::init('Member');
		$conditions = array('id' => explode(",", $ids));
		$order = array('id' => 'ASC');
		$data = $model->find('all', array('conditions' => $conditions, 'order' => $order));
		for($i=0; $i<count($data); $i++){
			$out[$i] = $data[$i]['Member']['name'];
		}
		return $out;
	}


	public function GetPlanName($id){
		$model = ClassRegistry::init('RatePlan');
		return $model->field('plan', array('id'=>$id));
	}


	public function IsDrinkFree($bumon, $drink_free_kind, $check_id=0){
//debug($drink_free_kind);
		if($drink_free_kind == 0)
			return false;

		$model = ClassRegistry::init('MenuMSTR');
		if(isset($bumon['cat2']))
			$conditions = array('menu_flag'=>0, 'cat1'=>$bumon['cat1'], 'cat2'=>$bumon['cat2'], 'order_no <'=>9970, 'flag16' => 0);
		else
			$conditions = array('menu_flag'=>0, 'cat1'=>$bumon['cat1'], 'order_no <'=>9970, 'flag16' => 0);
		
//debug($conditions);
		$order = array('order_no' => 'ASC');	//ASC | DESC
		$menu = $model->find('all', array('conditions' => $conditions, 'order' => $order));
//debug($menu);
		if(!$menu){
			//echo("エラー:メニューデータがありません。");
			//debug($conditions);
			return ""; 
		}
		$j = $k = 0;
		for($i=0; $i<count($menu); $i++){
			//$unitprice=$this->Common->GetUnitPrice($this->_room_no, $menu[$i]['MenuMSTR']['order_no']);
			
			if($drink_free_kind > 0){
				$drink_free_pattern = $menu[$i]['MenuMSTR']['drink_free_kind8'];

				if(strstr($drink_free_pattern, $drink_free_kind)){
					//$menu1[$j++]['MenuMSTR'] = $menu[$i]['MenuMSTR'];
					$order_no = $menu[$i]['MenuMSTR']['order_no'];
					if(!$this->CheckNightMenu($order_no, $check_id))
						$j++;

				}else{
					//$menu2[$k++]['MenuMSTR'] = $menu[$i]['MenuMSTR'];
					$k++;
				}
			}else{
				//$menu1[$j++]['MenuMSTR'] = $menu[$i]['MenuMSTR'];
				//$menu2 = array();
				$k++;
			}
		}
		if($j)
			return true;
		else
			return false;
	}

	public function GetCat2Num($cat1=0){
		$model = ClassRegistry::init('Bumon');
		
		$fields = array("fields" => "MAX(cat2) as max_n");
		$conditions = array("cat1" => $cat1);
		$data = $model->find('first', array('fields'=>$fields, 'conditions'=>$conditions));
//debug($data);
		$n = $data[0]['max_n'];
		if($n > 1)
			return true;
		else
			return false;
	}

	public function CheckNightMenu($order_no=0, $check_id=0){
		if($this->IsNightMenu($check_id)==0){
			return 0;
		}
		$model = ClassRegistry::init('MenuMSTR');
		$cat1 = $model->field('cat1', array('order_no'=>$order_no));
		$cat2 = $model->field('cat2', array('order_no'=>$order_no));

		$model = ClassRegistry::init('Bumon');
		$flag16 = $model->field('flag16', array('cat1'=>$cat1, 'cat2'=>$cat2));
		if(is_null($flag16))
			return 0;
		return $flag16;	//通常->0, 夜メニュー->1
	}

	public function IsNightMenu($check_id){
		$checkin_date = date("Y-m-d", substr(hexdec(substr($check_id, -10)), 0, 10));
		//$dt = '2023-04-3 00:00:03';
//debug($checkin_date);
		$checkin_date2 = date("Y-m-d", strtotime("+1 day", strtotime($checkin_date)));
//debug($checkin_date2);

		$model = ClassRegistry::init('Store');
		$t16 = $model->field('msg8', array('id'=>2));	//夜メニュー開始16時
		$t8 = $model->field('msg9', array('id'=>2));	//夜メニュー停止、翌日の86時

//$t16 = "12:00";
//$t8 = "13:35";
		if(!strstr($t16, ":"))
			$t16 .= ":00";
		if(!strstr($t8, ":"))
			$t8 .= ":00";

		$h16 = (int)$t16;
		$h8 = (int)$t8;
		
		if(($h8 > $h16) and ($h8 < 24)){/* 当日 */
			$time1 = new DateTime($checkin_date." ".$t16);
			$time2 = new DateTime($checkin_date." ".$t8);
		}else{
			$model = ClassRegistry::init('Store');
			$StoreOpen = $model->field('open_time', array('id'=>1));	//開店時間
			$time1 = new DateTime($StoreOpen);
			$time2 = new DateTime(date("H:i:s"));
			if($time1 < $time2){	/* 開店当日か？ */
//debug("開店当日でない");
				$time1 = new DateTime($checkin_date." ".$t16);
				$time2 = new DateTime($checkin_date2." ".$t8);
			}else{
//debug("開店当日です");
				$time1 = new DateTime(date("Y-m-d H:i:s",strtotime("-1 day ".$checkin_date." ".$t16)));
				$time2 = new DateTime(date("Y-m-d H:i:s",strtotime("-1 day ".$checkin_date2." ".$t8)));
			}
		}

		$now = new DateTime();

//debug($time1->format('Y-m-d H:i:s'));
//debug($time2->format('Y-m-d H:i:s'));
//debug($now->format('Y-m-d H:i:s'));

		if(!($now > $time1 and $now < $time2)){
//debug("夜メニューでない");
			return 1;//夜メニューでない。
		}
		return 0;
	}




	public function CheckOutOfStock($order_no=0){
		$model = ClassRegistry::init('MenuMod');
		$OutOfStock = $model->field('menu_flag', array('order_no'=>$order_no));
		if(is_null($OutOfStock))
			return 0;
		return $OutOfStock;	//通常->0, 品切れ->1
	}

	public function IsCheckin($room_no){
		$model = ClassRegistry::init('CheckDT1');
		$data = $model->find('first', array('conditions'=>array('room_no'=>$room_no), 'order' => 'id DESC'));
//debug($data);		
		if(isset($data['CheckDT1']['dt4_flag'])){
			if($data['CheckDT1']['dt4_flag'] > 1){
//debug($data['CheckDT1']['dt4_flag']);
//exit();
				return true;
			}else{
				return false;
			}
		}
//debug(isset($data['CheckDT1']['dt4_flag']));
//exit();
		return false;
	}


	public function GetDT4($room_no, $check_id=0){
		$model = ClassRegistry::init('CheckDT1');
		if($check_id)
			$dt4_flag = $model->field('dt4_flag', array('room_no'=>$room_no, 'check_id'=>$check_id), 'id DESC');
		else
			$dt4_flag = $model->field('dt4_flag', array('room_no'=>$room_no), 'id DESC');
		return $dt4_flag;
	}

	public function GetArg1($mode=1){
		if($mode==0)
			return date('Ymd-Hi');
		elseif($mode==1)
			return date('YmdH');
		else
			return date('Ymd');
	}


	public function ClearCartQty($room_no=0, $check_id="", $model_name="CartORD"){
		$model = ClassRegistry::init($model_name);
	    $old_model = ClassRegistry::init($model_name."Old");

		if($model_name == "CartORD")
			$order = array('order_time' => 'ASC');	//ASC | DESC
		else
			$order = array('up_date' => 'ASC');	//ASC | DESC
		$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id);
		$data = $model->find('all', array('conditions'=>$conditions, 'order' => $order));
		for($i=0; $i<count($data); $i++){
			$save_data = $data[$i][$model_name];
			$save_data['id'] = NULL;
//debug($save_data);
//exit();
			$old_model->save($save_data);
		}
		$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id);
		$ord = $model->deleteAll($conditions);
		return $ord;
//debug($ord);
//exit();
	}


	public function CeckOverOrder($room_no, $check_id){
		$model = ClassRegistry::init('CheckDT1');
		$order = array('id' => 'DESC');	//ASC | DESC
		$conditions = array('check_id'=>$check_id);
		$check = $model->find('first', array('conditions' => $conditions, 'order' => $order));
		if(isset($check['CheckDT1']['drink_free_kind']))
			$drink_free_kind = $check['CheckDT1']['drink_free_kind'];
		else
			return array(0,0);

		$model = ClassRegistry::init('CartORD');
		$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id, 'order_send_flag'=>0, 'unit_price'=>0,
			 'drink_free_kind8 LIKE'=> '%'.$drink_free_kind.'%');//
		$cart = $model->find('all', array('fields'=> array('sum(qty) as cnt'),'conditions' => $conditions));
//debug($cart);
		$count = $cart[0][0]['cnt'];
//debug($count);
		if(empty($count))
			$count = 0;
		
		if(isset($check['CheckDT1']['people'])){
			//$drink_free_kind = $check['CheckDT1']['drink_free_kind'];
			//if($drink_free_kind){
				$people = $check['CheckDT1']['people'];
//debug($people);
				return array($count, $people);
			//}
		}
		return array(0,0);
	}


	public function GetStoreMsg($msg, $id=1){
		$model = ClassRegistry::init('Store');
		return $model->field($msg, array('id'=>$id));
	}


	public function GetCartOrdQty($room_no=0, $check_id="", $order_no=0){
		$model = ClassRegistry::init('CartORD');
		if($order_no > 0){
			$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id, 'order_no'=>$order_no, 'order_send_flag'=>0);
			$ord = $model->find('first', array('conditions'=>$conditions));
			if(empty($ord))
				return 0;
			else
				return $ord['CartORD']['qty'];
		}elseif($order_no == -1){
			$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id, 'order_send_flag'=>0);
			$ord = $model->find('count', array('conditions'=>$conditions));
//debug($ord);
//exit();
			return $ord;
		}else{
			$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id, 'order_send_flag'=>0);
			$field = array('SUM(qty) AS qty_sum');
			$ord = $model->find('all', array('fields'=>$field,'conditions'=>$conditions));
//debug($ord);
//exit();
			if(empty($ord[0][0]['qty_sum']))
				return 0;
			else
				return $ord[0][0]['qty_sum'];
		}
	}


	public function GetCheckDT1($room, $check_id){
		$model = ClassRegistry::init('CheckDT1');
		$conditions = array('room_no' => $room, 'check_id' => $check_id);//, 'over_flag >'=>0, 'dt4_flag'=>0
		$order = array('id' => 'DESC');	//ASC | DESC
		$check = $model->find('first', array('conditions' => $conditions, 'order' => $order));
		if($check == array()){
			$conditions = array('room_no' => $room);
			$order = array('id' => 'DESC');	//ASC | DESC
			$check = $model->find('first', array('conditions' => $conditions, 'order' => $order));
			if($check == array())
				return array();
			else
				return $check['CheckDT1'];
		}else
			return $check['CheckDT1'];
	}

	public function GetLeaveRemainTime($room, $check_id){
//debug($room);
//debug($check_id);
		if(!$room)
			return "roomデータなし";
		if(!$check_id)
			return "check_idデータなし";

		$check = $this->GetCheckDT1($room, $check_id);
		if($check == array())
			return "該当データなし room=".$room." checkid=".$check_id;

		$now = time();
		$dt = strtotime($check['leave_remain_time']." minute", strtotime($check['up_date']));
		if($check['over_flag'] == 2){
			$diff = $dt - $now;
			if($diff > 0){
				$msg = "退室残り時間：";
			}else{
				$msg = "退室超過時間：";
				$diff = $now - $dt;
			}
		}elseif($check['over_flag'] == 3){
			$msg = "退室超過時間：";
			$diff = $now - $dt;
		}
//debug(date("Y-m-d H:i:s", $dt));
//debug(date("Y-m-d H:i:s", $now));
		return $msg.((int)($diff/60))."分";
	}



	public function GetDrinkFreeTime($room, $check_id){
		$check = $this->GetCheckDT1($room, $check_id);
//debug($check['drink_free_time']);
		if($check == array())
			return "";
//debug($check['drink_free_kind']);
		if($check['drink_free_kind'] == 0)
			return "";
//debug($check['drink_free_time']);
		$now = time();
		$dt = strtotime($check['drink_free_time']." minute", strtotime($check['up_date']));
		$diff = $dt - $now;
		if($diff > 0)
			return "飲み放題残り時間：".((int)($diff/60))."分";
		else
			return "飲み放題は終了してます";
	}


	public function CheckStaffService(){
		$model = ClassRegistry::init('MenuMSTR');
		$n = $model->find('count', array('conditions'=>array('order_no' > 9970)));
		return $n;
	}

	public function CountCat2($menu){
		$model = ClassRegistry::init('MenuMSTR');
		$group = array('cat2');
		$conditions = array('menu_flag' => 0, 'cat1' => $menu['cat1']);
  		$menu = $model->find('all', array('conditions' => $conditions, 'group'=>$group));
//debug($conditions);
		$n = count($menu);
//debug($n);
		if($n == 1){
			$cat2 = $menu[0]['MenuMSTR']['cat2'];
			if($cat2)
				return $cat2;
		}
		return 0;
	}

	public function DecodeCheckID($check_id){
		$s = hexdec($check_id);
//debug($s);
		$st = substr($s, 0, strlen($s)-2);
		$dt = date("Y-m-d H:i:s", (int)$st);
//debug($dt);
		$r = (int)substr($s, strlen($s)-2, 2);
//debug($r);
		return "(".$dt." ".$r.")";
	
	}

	public function MakeQrCode($url) {
		require_once("QrCodeHelper.php");	// 「QrCodeHelper.php」の読み込み
		$qrcode = new QrCodeHelper;		// インスタンスの作成
		//$url = "http://s.pierson1.shop/psp/staff/top_menu/1/1/平野";		// QRコードにする URLの指定
		// QRコードの表示
		return '<img src="' . $qrcode->text($url,["size"=>"200x200","encode"=>"UTF-8","margin"=>"2","error_correction"=>"L"]) . '">';
	}

	public function GetUnitPrice($room_no, $order_no, $alertFT=false, $cart_id=0){
		$model = ClassRegistry::init('CheckDT1');
  		$n = $model->field('unit_price_kind', array('room_no'=>$room_no), 'id DESC');
  		$drink_free_kind = $model->field('drink_free_kind', array('room_no'=>$room_no), 'id DESC');
		
		$model = ClassRegistry::init('MenuMSTR');
  		if($drink_free_kind > 0 and $alertFT==false){
			$drink_free_pattern = $model->field("drink_free_kind8", array('order_no'=>$order_no));
			if(strstr($drink_free_pattern, $drink_free_kind)){
				$unit_price = 0;
			}else{
		  		$unit_price = $model->field("unitprice".($n+1), array('order_no'=>$order_no));
			}
			if($cart_id > 0)
				$this->ChangeCartUnitPrice($cart_id, $unit_price);
		}else{
	  		$unit_price = $model->field("unitprice".($n+1), array('order_no'=>$order_no));
		}
		return $unit_price;
	}

	public function ChangeCartUnitPrice($cart_id, $unit_price){
		$model = ClassRegistry::init('CartORD');
		$model->set('id', $cart_id);
		$model->saveField('unit_price', $unit_price);
	}


	public function GetMenuName($order_no){
		$model = ClassRegistry::init('MenuMSTR');
  		$menu_name = $model->field('menu_name', array('order_no'=>$order_no), 'id ASC');	////ASC | DESC
		if(empty($menu_name))
			return "";
		return $menu_name;
	}
	
	public function GetMaxRoomNo(){
		$model = ClassRegistry::init('RoomInfo');
		$ret = $model->find('first', array('fields' => array("MAX(RoomID) as room_no_max")));
		$room_no_max = $ret[0]['room_no_max'];
		return (int)$room_no_max;
	}
	
	public function ConvRoomName($room_no){
		$model = ClassRegistry::init('RoomInfo');
  		$room_name = $model->field('RoomName', array('RoomID'=>$room_no));
		return $room_name;
	}

}