<?php
//	http://localhost:81/psp/kara/
//  https://s10.pierson1.shop/psp/kara/

if(file_exists('D:\xampp\htdocs\vendor\autoload.php'))
	require 'D:\xampp\htdocs\vendor\autoload.php';
else
	require ROOT . '/app/Vendor/autoload.php';
			// ROOT = '/home/gzenrzjd/public_html/s5/psp'
//use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as Writer;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as Reader;
use PhpOffice\PhpSpreadsheet\RichText\RichText as RichText; //RichTextAPIを使用
use PhpOffice\PhpSpreadsheet\Style;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;


use PhpOffice\PhpSpreadsheet\Writer\Pdf;


App::uses('AppController', 'Controller');
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');


class KaraController extends AppController {
	public $name = 'Kara';
	public $uses = array('Staff', 'User', 'RoomGroup', 'RoomInfo', 'Plan', 'CheckDT1', 'Member', 'RatePlan');
		//array('Store', 'Bumon', 'MenuMSTR', 'MenuMOD', 'RoomGroup', 'RoomInfo', 
		//					'CheckDT1', 'CartDT7', 'CartORD', 'Config', 'TopMenu',
	public $layout = 'kara';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_url = "";
	public $_path = WWW_ROOT;
	public $_server_name =  "";
	public $_server_name2 =  "";

	public $_up_date = "";

	public $_open_time = NULL;
	public $_close_time = NULL;
	public $_page_pattern = 0;
	public $_max_room_no = 10;

	public $_staff_name = "";

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/psp/";
		$this->set('_dir', $this->_dir);
		
//		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->_url .= "https://".$_SERVER['SERVER_NAME'].$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

/********** MOD 2023/06/18 ******************************************************/
		$this->_server_name =  substr($_SERVER['SERVER_NAME'], 0, strpos($_SERVER['SERVER_NAME'], ".") );
		$this->_store_id = preg_replace('/[^0-9]/', '', $this->_server_name);
/********** MOD 2023/06/18 ******************************************************/

		if($this->_server_name == "s.")
			$this->_server_name = "s";

		$this->set('_store_id', $this->_store_id);
		$this->set('_server_name', $this->_server_name);

		$this->_server_name2 =  " (".$this->_server_name.")";
		$this->set('_server_name2', $this->_server_name2);

		$main_title = "から次郎".$this->_server_name2;
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'kara', 'action' => 'top'));
	}
	
///======================================================///
	public function top($msg = ""){
		$top_title = $this->session_proc();
		$main_title = "TOPメニュー".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";


/*
			$room_no_max = $this->Common->GetRoomNoMax();



  `id` int(11) NOT NULL,
  `check_id` varchar(50) DEFAULT NULL,
  `room_no` tinyint(4) NOT NULL DEFAULT 0,
  `over_flag` tinyint(4) NOT NULL DEFAULT 0 COMMENT '2 or 3 超過0分から',
  `leave_remain_time` int(11) NOT NULL DEFAULT 0 COMMENT '退出残り時間（分単位）',
  `entry_close_time` int(11) NOT NULL DEFAULT 0 COMMENT '入室時から閉店までの時間（分単位）',
  `people` tinyint(4) NOT NULL DEFAULT 0,
  `unit_price_kind` tinyint(4) NOT NULL DEFAULT 0 COMMENT '単価種類',
  `drink_free_kind` tinyint(4) NOT NULL DEFAULT 0 COMMENT '飲み放題種類',
  `drink_free_time` int(11) NOT NULL DEFAULT 0 COMMENT '飲み放題残り時間',
  `dt4_flag` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'DT4 flag',
  `staff_call` tinyint(4) NOT NULL DEFAULT 0,
  `staff_call_time` datetime DEFAULT NULL,
  `up_date` datetime NOT NULL DEFAULT current_timestamp(),
  `staff_id` tinyint(4) NOT NULL DEFAULT 0,
  `member_id` varchar(50) DEFAULT NULL,
  `plan_id` tinyint(4) NOT NULL DEFAULT 0


  `id` int(11) NOT NULL,
  `RoomID` int(11) NOT NULL DEFAULT 0,
  `GroupID` int(11) NOT NULL DEFAULT 0,
  `RoomName` varchar(30) DEFAULT NULL,
  `OrderNo` int(11) NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0,

*/

		$staff_id = 0;

		$search['id'] = "";
		$search['RoomID'] = "";
		$search['GroupID'] = "";
		$search['RoomName'] = "";
		$search['OrderNo'] = "";
		$search['status'] = "";
		$staff_id = 0;

		$conditions = array();
		
		if($this->request->data){
			if(isset($this->request->data['Staff'])){
				$staff = $this->request->data['Staff'];
				if(isset($staff['id'])){
					$staff_id = $staff['id'];
					
				}else{
					$staff_id = 0;
				}
			}

			if(isset($this->request->data['RoomInfo'])){
				$search = $this->request->data['RoomInfo'];
				if(isset($search['id'])){
					$search['id'] = (int)mb_convert_kana($search['id'], "KVa");
					if($search['id']){
						$conditions['id'] = (int)$search['id'];
					}
				}else{
					$search['id'] = "";
				}

				if(isset($search['RoomID'])){
					if($search['RoomID']){
						$conditions['RoomID'] = (int)$search['RoomID'];
					}
				}else{
					$search['RoomID'] = "";
				}

				if(isset($search['RoomName'])){
					if($search['RoomName']){
						$conditions['RoomName like'] = '%'.$search['RoomName'].'%';
					}
				}else{
					$search['RoomName'] = "";
				}

				if(isset($search['status'])){
					if($search['status']){
						$conditions['status'] = (int)$search['status'];
					}
				}else{
					$search['status'] = "";
				}
			}
		}
//debug($conditions);
		$this->paginate = array(
			'RoomInfo' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 100,
				'order' => 'id', 		// desc
				'conditions' => $conditions,
				//'group' => array('flag', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('RoomInfo');
//debug($data);
//exit();
		$this->set('data', $data);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array();
		$data1 = $this->CheckDT1->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data1', $data1);
//debug($data1);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data2 = $this->Staff->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data2', $data2);
//debug($data2);

		$this->set('staff_id', $staff_id);
		$_SESSION['staff_id'] = $staff_id;

		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$msg = "";
		$this->set('msg', $msg);
//debug($data);
	}
//  https://s10.pierson.shop/psp/kara/


///======================================================///
	public function top_edit($room_no, $DT1ID, $member_list=""){
		$top_title = $this->session_proc();
		$main_title = "入室状況".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";
		$msg = "";

//debug($member_list);
//exit();
		if($member_list){
//debug($member_list);
			list($people, $member_id) = $this->ConvMember_id($member_list);
//debug($people);
//debug($member_id);
//exit();
		}else{
			$member_list = "";
			$people = 0;
			$member_id = "";
		}

		if($this->request->data){
//debug($this->request->data);
//exit();
			if(isset($this->request->data['RoomInfo']['submit'])){
				$save_data = $this->request->data['RoomInfo'];
				if(strstr($save_data['submit'], "更新") and $save_data['id'] > 0){
					$ret = $this->RoomInfo->save($save_data);
					$this->redirect(array('controller' => 'kara', 'action' => 'top'));
				}
			}

			if(isset($this->request->data['CheckDT1']['submit'])){
				$save_data = $this->request->data['CheckDT1'];
				if(strstr($save_data['submit'], "更新") and $save_data['id'] > 0){
//debug($save_data);
//exit();
					$ret = $this->CheckDT1->save($save_data);
					$this->redirect(array('controller' => 'kara', 'action' => 'top'));
				}elseif(strstr($save_data['submit'], "削除") and $save_data['id'] > 0){
					$this->CheckDT1->delete($save_data['id']);
					$DT1ID = 0;

					$conditions = array('RoomID' => $room_no);
					$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
					$this->RoomInfo->set('id', $room_id);
					$this->RoomInfo->saveField('status', 0);
					$this->redirect(array('controller' => 'kara', 'action' => 'top'));
				}
			}
		}

		$conditions = array('RoomID' => $room_no);
		$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
		$conditions = array('id'=>$room_id);	//'check_id'=>$this->_check_id
		$order = array();	//ASC | DESC
		$data = $this->RoomInfo->find('first', array('conditions' => $conditions, 'order' => $order));
		$this->set('data', $data);
//debug($search);
		$this->set('DT1ID', $DT1ID);

		if($DT1ID > 0){
			$conditions = array('id'=>$DT1ID);	//'check_id'=>$this->_check_id
			$order = array();	//ASC | DESC
			$data1 = $this->CheckDT1->find('first', array('conditions' => $conditions, 'order' => $order));

			if($_SESSION['staff_id'] > 0){
				$data1['CheckDT1']['staff_id'] = $_SESSION['staff_id'];

				$this->CheckDT1->set('id', $DT1ID);
				$this->CheckDT1->saveField('staff_id', $_SESSION['staff_id']);
			}

		}else{
			$data1 = array();
		}
		$this->set('data1', $data1);
//debug($data1);


		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data2 = $this->Staff->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data2', $data2);
//debug($data2);

		if($DT1ID > 0){
			$conditions = array('id' => $DT1ID);
			$staff_id = $this->CheckDT1->field("staff_id", $conditions, array('id DESC'));
		}else{
			$staff_id = 0;
		}
		$this->set('staff_id', $staff_id);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array();
		$data3 = $this->RoomInfo->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data3', $data3);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data4 = $this->RatePlan->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data4', $data4);
//debug($data4);

		$this->set("people", $people);
		$this->set("member_id", $member_id);
		$this->set("member_list", $member_list);

		$this->set('error_msg', $error_msg);
		//$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);

		$this->set('room_no', $room_no);
		$check_id = $data1['CheckDT1']['check_id']; 
		$this->set('check_id', $check_id);

//debug($data);
//debug($_SERVER['REQUEST_URI']);
//debug($_SERVER['SCRIPT_URI']);
//debug($_SERVER['SCRIPT_URL']);		//'/psp/kara/top_edit/1/20'
//debug($_SERVER['SCRIPT_NAME']);
//$a = explode("/", $_SERVER['SCRIPT_URL']);  $url1 = "/".$a[1]."/".$a[2]."/".$a[3]."/"; 	
//debug($url1);
//exit();
	}

	public function checkin($room_no=0, $DT1ID=0, $member_list=""){
		$top_title = $this->session_proc();
		$main_title = "新規入室メニュー".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";
		$msg = "";
		
		$plan = 0;


		if($member_list){
//debug($member_list);
			list($people, $member_id) = $this->ConvMember_id($member_list);
//debug($people);
//debug($member_id);
//exit();
		}else{
			$member_list = "";
			$people = 0;
			$member_id = "";
		}

//debug($this->request->data);
		if($this->request->data){
			if(isset($this->request->data['CheckDT1']['submit'])){
				$save_data = $this->request->data['CheckDT1'];
				if(strstr($save_data['submit'], "新規")){
					$save_data['id']=NULL;
				
					$save_data['leave_remain_time'] = ($save_data['hour1'] * 60) + $save_data['minutes1'];
					$save_data['drink_free_time'] = ($save_data['hour1'] * 60) + $save_data['minutes1'];
					list($save_data['people'], $save_data['member_id']) = $this->ConvMember_id($save_data['member_list']);

					if($this->CheckDT1->save($save_data)){
						$DT1ID = $this->CheckDT1->getLastInsertID();
//debug($DT1ID);
//debug($save_data);
						$conditions = array('RoomID' => $room_no);
						$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
						$this->RoomInfo->set('id', $room_id);
						$this->RoomInfo->saveField('status', 1);	//入室

//						$this->redirect(array('controller' => 'kara', 'action' => 'top'));

						$_SESSION['staff_id'] = $save_data['staff_id'];
						$_SESSION['room_no'] = $save_data['room_no'];
						$_SESSION['people'] = $save_data['people'];
						$_SESSION['member_id'] = $save_data['member_id'];
						$_SESSION['member_list'] = $save_data['member_list'];
						$_SESSION['DT1ID'] = $DT1ID;
						$_SESSION['plan_id'] = $save_data['plan_id'];

//debug($_SESSION);
//exit();
						$this->redirect(array('controller' => 'kara', 'action' => 'top_edit', $room_no, $DT1ID, $save_data['member_list'] ));
					}					
				}
			}elseif(isset($this->request->data['Member']['members'])){
				$member_list = $this->request->data['Member']['members'];
				
				list($people, $member_id) = $this->ConvMember_id($member_list);

/*				
				$members = explode('|', $member_list);
				$people = count($members);
				if($people > 0){
					for($i=0; $i<$people; $i++){
						list($member_no[$i], $name[$i]) = explode('・', $members[$i]);
						$conditions = array('member_no' => $member_no[$i]);
						$m_id[$i] = $this->Member->field("id", $conditions, array('id DESC'));
					}
					$member_id = implode(",", $m_id);
				}
*/

//debug($member_no);
//debug($name);
//debug($m_id);
//debug($member_id);
//exit();
			}
		}

		if($DT1ID > 0){
			$conditions = array('id'=>$DT1ID);	//'check_id'=>$this->_check_id
			$order = array();	//ASC | DESC
			$data1 = $this->CheckDT1->find('first', array('conditions' => $conditions, 'order' => $order));


/*
			if($_SESSION['staff_id'] > 0){
				$data1['CheckDT1']['staff_id'] = $_SESSION['staff_id'];

				$this->CheckDT1->set('id', $DT1ID);
				$this->CheckDT1->saveField('staff_id', $_SESSION['staff_id']);
			}
*/

		}else{
			$data1 = array();
		}


		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data2 = $this->Staff->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data2', $data2);
//debug($data2);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('RoomID' => $room_no);
		$data3 = $this->RoomInfo->find('first', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data3', $data3);
//debug($data3);


		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data4 = $this->RatePlan->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data4', $data4);
//debug($data4);


		if(isset($_SESSION['staff_id']))
			$staff_id = $_SESSION['staff_id'];
		else
			$staff_id = 0;
		$this->set('staff_id', $staff_id);

		$this->set('room_no', $room_no);
	
		$this->set("people", $people);
		$this->set("member_id", $member_id);
		$this->set("member_list", $member_list);
		$this->set('DT1ID', $DT1ID);
		$this->set('plan', $plan);

		$this->set('error_msg', $error_msg);
		//$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);

		$_SESSION['staff_id'] = $staff_id;
		$_SESSION['room_no'] = $room_no;
		$_SESSION['people'] = $people;
		$_SESSION['member_id'] = $member_id;
		$_SESSION['member_list'] = $member_list;
		$_SESSION['DT1ID'] = $DT1ID;
		$_SESSION['plan'] = $plan;

		$this->set('session', $_SESSION);

//debug($_SERVER['REQUEST_URI']);
//debug($_SERVER['SCRIPT_URI']);
//debug($_SERVER['SCRIPT_URL']);
//debug($_SERVER['SCRIPT_NAME']);
	}


/*
///======================================================///
	public function staff($msg = ""){
		//$this->autoLayout = false;  // レイアウトをOFFにする
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$main_title = "担当者選択".$this->_server_name2;
		$error_msg = "";

		$search['id'] = "";
		$search['name'] = "";
		$search['flag'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
			if($this->request->data['submit'] == "更新"){
				$staffs = $this->request->data;
//debug(count($staffs));
				for($i=0; $i<count($staffs); $i++){
					if(isset($staffs[$i]['Staff']['id'])){
//debug($staffs[$i]['Staff']['id']);
						$this->Staff->set('id', $staffs[$i]['Staff']['id']);

						if(!isset($staffs[$i]['Staff']['flag'])){
							$staffs[$i]['Staff']['flag'] = 0;
							$this->Staff->saveField('flag', 0);
						}else{
							$staffs[$i]['Staff']['flag'] = 1;
							$this->Staff->saveField('flag', 1);
						}
					}
				}
			}
			
			if(isset($this->request->data['Staff'])){
				$search = $this->request->data['Staff'];
			}else{
				$search = array();
			}
//debug($search);

			if(isset($search['id'])){
				$search['id'] = (int)mb_convert_kana($search['id'], "KVa");
				if($search['id']){
					$conditions['id'] = (int)$search['id'];
				}
			}else{
				$search['id'] = "";
			}

			if(isset($search['name'])){
				if($search['name']){
					$conditions['name like'] = '%'.$search['name'].'%';
				}
			}else{
				$search['name'] = "";
			}

			if(isset($search['flag'])){
				if($search['flag'] == 1){
					$conditions['flag'] = 0;
				}
			}else{
				$search['flag'] = "";
			}

		}
		
			
//debug($conditions);
		$this->paginate = array(
			'Staff' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'id', 		// desc
				'conditions' => $conditions,
				//'group' => array('flag', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('Staff');
//debug($data);
//exit();

		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function staff_edit($staff_id = 0){
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$staff_name = "";
		$main_title = "担当者選択(Staff)".$this->_server_name2;

//debug($this->request->data);
		if($this->request->data){
			$staff = $this->request->data['Staff'];
//debug($staff);
//exit();
			if ($staff['submit'] == "削除"){
//debug($staff);
				$this->Staff->delete($staff['id']);
				$this->redirect(array('controller' => 'kara', 'action' => 'staff'));

			}
			if ($staff['submit'] == "更新" or strstr($staff['submit'], "新規")){
				if(!isset($staff['flag']))
					$staff['flag'] = 0;
				else
					$staff['flag'] = 1;
			}
			
			if ($staff['submit'] == "更新"){
				$staff['flag'] = mb_convert_kana($staff['flag'], "KVa");
				if($staff['id'] > 0){
					$staff_id = $staff['id'];
//debug($staff);
					$ret = $this->Staff->save($staff);
//exit();
					$this->redirect(array('controller' => 'kara', 'action' => 'staff'));
				}
			}elseif(strstr($staff['submit'], "新規")){
				$staff['flag'] = mb_convert_kana($staff['flag'], "KVa");
				$conditions = array('name like'=>$staff['name']);
				$data = $this->Staff->find('first', array('conditions'=>$conditions));
				if(count($data) == 0){
					$staff_id = $staff['id'] = null;
					$ret = $this->Staff->save($staff);
					$this->redirect(array('controller' => 'kara', 'action' => 'staff'));
				}
				$msg = $data['Staff']['name']."　は既にデータがあります";

			}else{
				debug("エラー");
				//exit();
			}

		}

		if($staff_id > 0){
			$conditions = array('id'=>$staff_id);
			$data = $this->Staff->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($staff_id > 0)
				$error_msg = "データがない";
		}
//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

*/


///======================================================///
	public function member($msg = ""){
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$main_title = "会員選択".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		$search['id'] = "";
		$search['member_no'] = "";
		$search['name'] = "";
		$search['memo'] = "";
		$search['grade'] = "";
		$search['birthday'] = "";
		$search['expiration'] = "";
		$search['usage_amount'] = "";
		$search['visits'] = "";
		$search['last_visit'] = "";
		$search['point'] = "";
		$search['table1'] = "";
		$search['table2'] = "";
		$search['table3'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
			$search = $this->request->data['Member'];
			if(isset($search['member_no'])){
				$search['member_no'] = mb_convert_kana($search['member_no'], "KVa");
				if($search['member_no']){
					$conditions['member_no'] = $search['member_no'];
				}
			}else{
				$search['member_no'] = "";
			}
			if(isset($search['name'])){
				if($search['name']){
					$conditions['name like'] = '%'.$search['name'].'%';
				}
			}else{
				$search['name'] = "";
			}

			if(isset($search['memo'])){
				if($search['memo']){
					$conditions['memo like'] = '%'.$search['memo'].'%';
				}
			}else{
				$search['memo'] = "";
			}

			if(isset($search['grade'])){
				if($search['grade']){
					$conditions['grade'] = $search['grade'];
				}
			}else{
				$search['grade'] = "";
			}

			if(isset($search['birthday'])){
				if($search['birthday']){
					$conditions['birthday like'] = '%'.$search['birthday'].'%';
				}
			}else{
				$search['birthday'] = "";
			}
		}
		
			
//debug($conditions);
//exit();
		$this->paginate = array(
			'Member' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'name', 		// desc
				'conditions' => $conditions, 
			), 
		);
//debug($search);
		$data = $this->paginate('Member');
		$this->set('data', $data);

		$conditions = array();	//'check_id'=>$this->_check_id
		$order = array('member_no' => 'ASC');	//ASC | DESC
		$data1 = $this->Member->find('all', array('conditions' => $conditions, 'order' => $order));
		$this->set('data1', $data1);

		$this->set('error_msg', $error_msg);
		$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
//exit();
	}	

	public function member_edit($member_id=0){
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$room_name = "";
		$main_title = "会員選択(Member)".$this->_server_name2;

		if($this->request->data){
			$member = $this->request->data['Member'];
//debug($member);
//exit();
			if ($member['submit'] == "削除"){
//debug($member);
				$this->Member->delete($member['id']);
				$this->redirect(array('controller' => 'kara', 'action' => 'member'));

			}elseif ($member['submit'] == "更新"){
				$member['status'] = mb_convert_kana($member['status'], "KVa");
				if($member['id'] > 0){
					$member_id = $member['id'];
//debug($member);
					$ret = $this->Member->save($member);
					$this->redirect(array('controller' => 'kara', 'action' => 'member'));
				}
			}elseif ($member['submit'] == "新規"){
//debug($member);
				$member['status'] = mb_convert_kana($member['status'], "KVa");
				if(!$member['member_no']){
					$msg = "会員番号がありません";
				}elseif(!$member['name']){
					$msg = "会員名がありません";
				}elseif(!$member['grade']){
					$msg = "会員グレードがありません";
				}elseif(!$member['birthday']){
					$msg = "誕生日がありません";

				}else{
					$conditions = array('member_no'=>$member['member_no']);
					$data = $this->Member->find('first', array('conditions'=>$conditions));
					if(count($data) == 0){
						$member['id'] = null;
						$ret = $this->Member->save($member);
						$this->redirect(array('controller' => 'kara', 'action' => 'member'));
					}
					$msg = $data['Member']['member_no']."　は既にデータがあります";
				}
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Room");	//'

		if($member_id > 0){
			$conditions = array('id'=>$member_id);
			$data = $this->Member->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($member_id > 0)
				$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);	
	}




///======================================================///

	public function plan($msg = ""){
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$main_title = "料金選択".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		$search['id'] = "";
		$search['plan'] = "";
		$search['comment'] = "";
		$search['flag'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
//debug($this->request->data['RatePlan']);
			$search = $this->request->data['RatePlan'];
			if(isset($search['id'])){
				if($search['id']){
					$conditions['id'] = $search['id'];
				}
			}else{
				$search['id'] = "";
			}
			if(isset($search['plan'])){
				if($search['plan']){
					$conditions['plan like'] = '%'.$search['plan'].'%';
				}
			}else{
				$search['plan'] = "";
			}

			if(isset($search['comment'])){
				if($search['comment']){
					$conditions['comment like'] = '%'.$search['comment'].'%';
				}
			}else{
				$search['comment'] = "";
			}
			if(isset($search['flag'])){
				if($search['flag'] == 1){
					$conditions['flag'] = 0;
				}
			}else{
				$search['flag'] = "";
			}

		}
		
			
//debug($conditions);
//exit();
		$this->paginate = array(
			'RatePlan' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'id', 		// desc
				'conditions' => $conditions, 
				//'group' => array('flag', 'checkin_time'),
			), 
		);
		$data = $this->paginate('RatePlan');
		$this->set('data', $data);
//debug($search);
		$this->set('error_msg', $error_msg);
		$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function plan_edit($plan_id=0){
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$room_name = "";
		$main_title = "プラン選択(RatePlan)".$this->_server_name2;

		if($this->request->data){
			$plan = $this->request->data['RatePlan'];
//debug($plan);
//exit();
			if ($plan['submit'] == "削除"){
//debug($plan);
				$this->RatePlan->delete($plan['id']);
				$this->redirect(array('controller' => 'kara', 'action' => 'plan'));

			}elseif ($plan['submit'] == "更新"){
				$plan['flag'] = mb_convert_kana($plan['flag'], "KVa");
				if($plan['id'] > 0){
					$plan_id = $plan['id'];
//debug($plan);
					$ret = $this->RatePlan->save($plan);
					$this->redirect(array('controller' => 'kara', 'action' => 'plan'));
				}
			}elseif ($plan['submit'] == "新規"){
//debug($plan);
				$plan['flag'] = mb_convert_kana($plan['flag'], "KVa");
				if(!$plan['plan']){
					$msg = "プラン名がありません";
				}else{
					$conditions = array('plan'=>$plan['plan']);
					$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
					if(count($data) == 0){
						$plan['id'] = null;
						$ret = $this->RatePlan->save($plan);
						$this->redirect(array('controller' => 'kara', 'action' => 'plan'));
					}
					$msg = $data['RatePlan']['plan']."　は既にデータがあります";
				}
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Room");	//'

		if($plan_id > 0){
			$conditions = array('id'=>$plan_id);
			$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($plan_id > 0)
				$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);	
	}





/*
	public function download_staff(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_Staff.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'Staff'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");

		/--------------------------------------------/
		$items = array('id','名前','有効/無効','更新日');
		/--------------------------------------------/

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->Staff->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}
*/


	private function download_sub($items, $data, $output_file_path, $outputFile){
		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		//$book->getDefaultStyle()->getFont()->setName( 'ＭＳ ゴシック' );
		$book->getDefaultStyle()->getFont()->setName( 'HG丸ｺﾞｼｯｸM-PRO' );
		$book->getDefaultStyle()->getFont()->setSize( 12 );

 		//$sheet->setTitle(date("Y年m月d日 H時i分s秒"));
// 		$sheet->setTitle(date("Sheet1"));

		//=============================================================
		$row = 1;
		foreach ($items as $col => $value) {
        	$sheet->setCellValueByColumnAndRow($col+1, $row, $value);
			
			$objStyle = $sheet->getStyleByColumnAndRow($col+1, $row);	// スタイルオブジェクト取得([B2]セル)
			$objFill = $objStyle->getFill();	// フィルオブジェクト取得([B2]セル)
			$objFill->setFillType(Fill::FILL_SOLID);	// 背景のタイプを「塗つぶし」に設定
			$objFill->getStartColor()->setARGB('4000FF00');	// 背景色を「赤」に設定
		}


		$rowOffset = 2;
		for($i=0; $i<count($data); $i++){
			$data1 = $data[$i];
//debug($data1);
			$this->WriteExcel($sheet, $data1, $rowOffset);
			$rowOffset++;
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);
//exit();

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}



	private function WriteExcel($sheet, $data, $rowOffset){
		foreach ($data as $row => $fields) {
//debug($fields);
//debug($row);
//exit();
//		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 1;
			    foreach ($fields as $field => $value) {
//debug($col);
//debug($row);
//debug($rowOffset);
//debug($col);
//debug($value);
					
        			$sheet->setCellValueByColumnAndRow($col++, 0 + $rowOffset, $value);
//exit();
				}
//exit();
//    		}
		}
	}


/** ============================================================================================================= */
/*
	public function upload_staff(){		//EXCELL UPLOAD		RoomInfo		Staff
		$error_msg = "";
		$this->set('main_title', "スタッフ管理".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/Staff/Staff.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					///==========================================
					$fields = array('id','name','flag','up_date');
					///==========================================
					$data = $this->ReadExcell($file_path, $fields);

					$this->Staff->truncate();
					$this->Staff->saveAll($data);
					$this->redirect(array('controller' => 'kara', 'action' => 'staff'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}


*/


	private function ReadExcell($file_path, $fields){
//debug($file_path);
//debug($fields);
//exit();
		if(!file_exists($file_path)){
			debug("ファイルが無い：".$file_path);
			exit();
		}
		
		$reader = new Reader();
		$spreadsheet = $reader->load($file_path); // ファイル名を指定

		$sheet = $spreadsheet->getActiveSheet();
		//$sheet = $spreadsheet->getSheetByName('Worksheet'); // 読み込むシートを指定
		//$sheet = $spreadsheet->getSheet(0);

		$lastrow = $sheet->getHighestRow(); //200などの数字
		$lastcolname = $sheet->getHighestColumn(); //AZなどの文字列
		$lastcol = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($lastcolname); //これで数字になる

//debug($lastrow);
//debug($lastcolname);
//debug($lastcol);
//debug(count($fields));
//exit();
		$data1 = array();
		for($row=2; $row<=$lastrow; $row++){
			for($col=1; $col<=$lastcol; $col++){
				$data1 = array_merge($data1, [$fields[$col-1] => $sheet->getCellByColumnAndRow($col,$row)->getValue()]);
			}
			$data1['id'] = $row - 1;
			$data[$row - 2] = $data1;
		}

/*
		$i = 0;
		$data = array();
		foreach ($sheet->getRowIterator() as $row) {
			$j = 0;
			$data1=array();
			foreach($sheet->getColumnIterator() as $column){
				$data1 = array_merge($data1, [$fields[$j] => $sheet->getCell($column->getColumnIndex() . ($row->getRowIndex()+1))->getValue()]);	//.PHP_EOL;
				$j++;
			}
			if($data1[$fields[2]] == null)
				break;
			$data1['id'] = $i+1;
			$data[$i] = $data1;
debug($data1);
debug($data[$i][$fields[2]]);
exit();
			$i++;
		}
*/

//debug($data[0]);
//debug($data[1]);
//debug($data[count($data)-2]);
//debug($data[count($data)-1]);
//exit();
		return $data;
		//PhpSpreadsheet
	}

/** ============================================================================================================= */
/** ============================================================================================================= */
/** ============================================================================================================= */






	private function ConvMember_id($member_list){
		if($member_list == "")
			return array(0, "");

		$members = explode('|', $member_list);
		$people = count($members);
		$member_id = "";
		$member_no = $name = array();
		if($people > 0){
			for($i=0; $i<$people; $i++){
				list($member_no[$i], $name[$i]) = explode('・', $members[$i]);
				$conditions = array('member_no' => $member_no[$i]);
				$m_id[$i] = $this->Member->field("id", $conditions, array('id DESC'));
			}
			$member_id = implode(",", $m_id);
		}
		return array($people, $member_id);
	}

///======================================================///

	private function session_proc(){
		$top_title = "";
		session_start();

		foreach ($_SESSION as $key => $value){
			$top_title .= $key."：".$value."　";
		}
		return $top_title;
	}



}
?>