<?php
class ExcelComponent extends Object {

    var $errors = array();

		/** Main Class */
		//require_once Classes."phpexcel/PHPExcel.php";
		/** IO Class */
		//require_once Classes."phpexcel/PHPExcel/IOFactory.php";


    /**
     * readXls - Excelt@Cǂݍ
     * 
     *
     * @param string $filepath
     * @param int $colCount (Optional)
     * @param int $rowCount (Optional)
     * @param mix $sheetIndex (Optional) ǂݍݑΏ
     * @return array ǂݍ񂾃f[^
     */
    function readXls($filepath, $colCount = null, $rowCount = null, $sheetIndex = null) 
    {
        //include the vendor class
        App::import('vendor','phpexcel/phpexcel');

        //t@Cǂݍ
        //$objReader = PHPExcel_IOFactory::createReader('Excel5');
		$objReader = PHPExcel_IOFactory::createReader('Excel2007');

        $objPHPExcel = $objReader->load($filepath);

        //V[gIuWFNg̎擾
        $sheets = array();
        if (is_null($sheetIndex)) {
            //ׂ
            $sheets = $objPHPExcel->getAllSheets();
        } elseif (is_array($sheetIndex)) {
            foreach($sheetIndex as $idx) {
                $sheets[$idx] = $objPHPExcel->getSheet($idx);
            } 
        } elseif (is_int($sheetIndex)) {
            $sheets[$sheetIndex] = $objPHPExcel->getSheet($sheetIndex);
        }
        $data = array();
        if (empty($sheets)) {
            return $data;
        }

        //1V[gƏ
        foreach ($sheets as $s => $objSheet) {
            //V[g̎擾
            $sheetTitle = $objSheet->getTitle();
            $data[$s]['title'] = $sheetTitle;

            //f[^̈mF
            $rowMax = $rowCount;
            if (is_null($rowCount)) {
                $rowMax = $objSheet->getHighestRow();
            }
            $colMax = $colCount;
            if (is_null($colCount)) {
                $colMax = $objSheet->getHighestColumn();
            }

            //1ZƂɃeLXgf[^擾
            $sheetData = array();
            for($r=1; $r<=$rowMax; $r++) { //row1͂܂
                 for($c=0; $c<=$colMax; $c++) { //col0͂܂ 0 = AƂȂ
                     $objCell = $objSheet->getCellByColumnAndRow($c, $r);

                     $sheetData[$r][$c]= $this->_getText($objCell);
                 }
             }
             $data[$s]['data'] = $sheetData;
        }
        return $data;
    }

    /**
     * w肵Z̕擾
     *
     * FÂꂽZȂǂ cell->getValue()ŕ݂̂擾łȂ
     * ܂A̔zɕf[^Ă܂̂ŁA̕AĕԂ
     *
     *
     * @param <type> $objCell CellIuWFNg
     */
    function _getText($objCell = null)
    {
         if (is_null($objCell)) {
             return false;
         }

         $txtCell = "";

         //܂getValue()s
         $valueCell = $objCell->getValue();

         if (is_object($valueCell)) {
             //IuWFNgԂĂAb`eLXgvf擾
             $rtfCell = $valueCell->getRichTextElements();
             //zŕԂĂ̂ŁA炳ɕ𒊏o
             $txtParts = array();
             foreach ($rtfCell as $v) {
                $txtParts[] = $v->getText();
             }
             //A
             $txtCell = implode("", $txtParts);

         } else {
             if (!empty($valueCell)) {
                 $txtCell = $valueCell;
             }
         }

         return $txtCell;
    }



	function num2time($num){
		$h0 = $num * 24;
		$h1 = floor($h0);
		$h2 = $h0 - $h1;

		$m0 = $h2 * 60;
		$m1 = floor($m0);
		$m2 = $m0 - $m1;

		$s0 = $m2 * 60;
		$s1 = floor($s0);
		//$s2 = $s0 - $s1;
		
		//return $num ."= ". sprintf("%02d:%02d:%02d", $h1, $m1, $s1);
		return sprintf("%2d:%02d:%02d", $h1, $m1, $s1);
	}







    /**
     * write - Excelt@Cɏ
     *
     * @param string $filepath ev[gt@C̃pX
     * @param array  $data
     * @param boolean $is_copy $filepath ev[gɂăRs[t@C邩
     */
    function writeXls($filepath, $data = array(), $is_copy = true)
    {
        //include the vendor class
        App::import('vendor','phpexcel/phpexcel');

        //t@Cǂݍ
        $objReader = PHPExcel_IOFactory::createReader('Excel5');
        $objPHPExcel = $objReader->load($filepath);
        // set active sheet
        foreach ($data as $s => $rows) {
            $objPHPExcel->setActiveSheetIndex($s);
            $sheet = $objPHPExcel->getActiveSheet();
            
            foreach ($rows['data'] as  $r => $cols) {
                foreach ($cols as $c => $v) {
                    // update cell
                    $sheet->setCellValueByColumnAndRow($c, $r+1, $v);
                }
            }
        }
        if ($is_copy) {
            $target_filepath = TMP . "output_". date("YmdHis") .".xls"; //t@C
        } else {
            $target_filepath = $filepath;
        }

        //ۑ̃f[^̓pXƃt@CɕKv
        $target_basename = basename($target_filepath);
        $target_dir = dirname($target_filepath);

        // output excel file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->setTempDir($target_dir);
        $objWriter->save($target_filepath);

        return $target_filepath;
    }


    /**
    * _E[h
    */
    function download()
    {
        //o̓f[^z̐
    //    $writeData = array(...);

        //Excelɏo
        $return = $this->Excel->writeXls(WWW_ROOT . 'files/templates.xls', $writeData);

        //G[`FbN (ȗ)

        //t@Cł
        //_E[hJn
        $media_id = basename($return);
        $media_name = substr($media_id, 0, strlen($media_id) - 4);

        $this->view ='media';
        $params = array(
            'id' => $media_id,
            'name' => $media_name,
            'download' => true,
            'extension' => 'xls',
            'path' => dirname($return) . DS,
            'mime' => "application/vnd.ms-excel"
            );

        $this->set($params);
    }


    /**
    * Abv[h
    */
    function upload(){

        // ꊇAbv[ht@CmF
        $tmp_path = TMP . 'upload_file.xls';
        $filename = $this->Excel->import($this->data['upload_file'], true, $tmp_path);
        if (!empty($this->Excel->errors)) {
            $this->Session->write('error_message', $this->Excel->errors);
            $this->redirect("/sample/index");
        }
        
        //f[^̓ǂݍ
        $readData = $this->Excel->readXls($filename,11);

        //ǂݍ݌̏ (ȗ)
    }


    /**
     * import - Excelt@Cǂݍ
     */
    function import($file, $is_move_file = false, $destination = '', $type = "xls")
    {
    }

}

?>
