<?php
//	REF:http://www.webdesignersblog.jp/archives/2010/02/10192251.php

class CommonComponent extends Object
{
	var $components = array('Cookie', 'Session', 'Qdmail');


	function is_mobile(){
	    $user_agent = $_SERVER['HTTP_USER_AGENT']; // HTTP ヘッダからユーザー エージェントの文字列を取り出す
    	return preg_match('/iphone|ipod|ipad|android/ui', $user_agent) != 0; // 既知の判定用文字列を検索
	}

	function get_date_num($date_str){
		list($date, $time) = explode(" ", $date_str);
		$date_num = str_replace("-", "", $date);
		return substr($date_num, 2);
	}
	
	function get_plan_data($plan_id=0){
		$model = ClassRegistry::getObject('Plan'); 
		$plan_data = $model->find('first', array('conditions' => array("id" => $plan_id) ));
		return $plan_data;
	}

	function sum_people($peoples_str){
		$peoples = explode(",", $peoples_str);
		$sum = 0;
		for($i=0; $i<count($peoples); $i++){
			$sum += $peoples[$i];
		}
		return $sum;
	}

	function get_implode($peoples_str, $n){
//debug("str=[".$peoples_str."]", false, false);
//debug($peoples_str);
		$peoples = explode(",", $peoples_str);
		if(isset($peoples[$n]))
			return $peoples[$n];
		else
			return "-";
	}
	function get_implode_n($peoples_str, $n){
		if($n > 6)
			$n = 6;
		$num = $this->get_implode($peoples_str, $n);
		if($num == "-")
			return $num;
		else
			return number_format($num);
	}

	
	
	public function make_mail_proc($user_data, $book_data, $filename="newreg_mail.txt"){
		$text = file_get_contents(WWW_ROOT."files/".$filename);
		$text = str_replace("\r", "", $text);
		$text = str_replace("\a", "", $text);
//debug($user_data);
		$lines = explode("\n", $text);
		$subject = $body = "";
		for($i=0; $i<count($lines); $i++){
			//echo $lines[$i]."<br>";
			if($i == 0)
				$subject = $lines[$i];
			else
				$body .= $lines[$i]."\n";
		}
		$items = array("mail", "username", "password", "name", "name_furi", "mailC", "pref", "post", "city", "twn_add", "bild", "Contact", "tel", "Ctime");
		for($i=0; $i<count($items); $i++){
			$body = str_replace("<?".$items[$i]."?>", $user_data[ $items[$i] ], $body);
		}
		
		if(strstr($filename, "cancel_mail.txt") || strstr($filename, "booking_mail.txt")){
			$items = array("Rtime", "TRF", "memo", "text");
			for($i=0; $i<count($items); $i++){
				$body = str_replace("<?".$items[$i]."?>", $book_data[ $items[$i] ], $body);
			}
		}
	//	echo $subject."<br>";
	//	echo nl2br($body)."<br>";
	//exit();
		return array($subject, $body);
//		list($subject, $mailbody)
	}
	

	public function redirect_post($url, $data){
//debug($data);
		$data = http_build_query($data, "", "&");
		$header = array(
    		"Content-Type: application/x-www-form-urlencoded",
			"Content-Length: ".strlen($data)
			);

		$context = array(
			"http" => array(
      		"method"  => "POST",
      		"header"  => implode("\r\n", $header),
        	"content" => $data
    		)
		);

		echo file_get_contents($url, false, stream_context_create($context));
		exit();
	}










	public function download_proc($obj){
		$key = $this->key;

		$data = $obj->Shop->find('all', array('order' => array('id ASC')));
		$data = $this->utf82sjis($data);

		$filename = "shoplist".date("Ymd-hi").".csv";
		$path_filename = WWW_ROOT."files/download/".$filename;
		if(file_exists($path_filename))
			unlink($path_filename);
		if (!$handle = fopen($path_filename, 'a')) {
			echo "Cannot open file ($path_filename)";
			exit;
		}

		for($i=0; $i<count($data); $i++){
			$line = "";
			for($j=1; $j<count($key); $j++){
				if($j != 1)
					$line .= ",";
				$line .= "\"".$data[$i]['Shop'][ $key[$j] ]."\"";
			}
			//echo "line=[".$line."]<hr>";
			if (fwrite($handle, $line."\n") === FALSE) {
				echo "Cannot write to file ($filename)";
				exit;
			}
		}
		fclose($handle);
		chmod($path_filename, 0777);
		/////////////////////////////////////////////////////////////////////////////
		if( !is_file($path_filename) ){
			return false;
		}

		$this->autoRender = false; // Viewを使わないように
		Configure::write('debug', 0); // debugコードを出さないように

		$fp = fopen($path_filename, 'rb');
		$buf = fread($fp, filesize($path_filename));

		header ("Content-disposition: attachment; filename=" . $filename);
		header ("Content-type: application/octet-stream; name=" . $filename);
		print($buf); // 出力
		exit;
		return true;
	}


	public function save_csv_line($shop, $line){
		$data = explode(",", $line);
		$j = 1;
		$key = $this->key;

		$data1[$key[0]] = null;
		$str1 = null;
		for($i=0; $i<count($data); $i++){
			if(!isset($key[$j])){
				echo "Error: CSVファイルのフィールド数が不足<hr>";
				print_r($data1);
				exit;
			}
			if(substr($data[$i], 0, 1) == "\x22"){
				if(substr($data[$i], -1) == "\x22"){
					$data1[$key[$j++]] = substr($data[$i], 1, strlen($data[$i]) - 2);
					//echo "str1=[".$data1[$key[$j++]]."]<br>";
				}else{
					$str1 = substr($data[$i], 1).",";
				}
			}else{
				if(substr($data[$i], -1) == "\x22"){
					if($str1){
						$data1[$key[$j++]] = $str1.substr($data[$i], 0, strlen($data[$i]) - 1);
						//echo "str3=[".$data1[$key[$j++]]."]<br>";
					}else{
						$data1[$key[$j++]] = substr($data[$i], 0, strlen($data[$i]) - 1);
						//echo "str2=[".$data1[$key[$j++]]."]<br>";
					}

				}else{
					if($str1)
						$str1 .= $data[$i].",";
					else{
						$data1[$key[$j++]] = $data[$i];
						//echo "str0=[".$data1[$key[$j++]]."]<br>";
					}
				}
			}
		}
		//-------------------------------------------------------------
		//print_r($data1);
		//exit;
		$data1 = $this->sjis2utf8($data1);
		if($shop->save($data1)){
			return true;
		}else{
			//$this->AppliSub->error_proc($shop->invalidFields(), "Shop");
			echo "Error: ファイル保存";
			exit;
			return false;
		}
	}

	public function make_html($id, $html_text=""){
		$html_file = WWW_ROOT."files/html/auth.html";
		$file = new File($html_file, true);
		$html_text = $file->read().$html_text;
		$file->close();

		$html_file = WWW_ROOT."files/html/".$id.".html";
		if(file_exists($html_file))
			unlink($html_file);

		$file = new File($html_file, true);
		$file->write($html_text);
		$file->close();
		chmod($html_file, 0666);

		App::import('Helper', 'Html');
		$html = new HtmlHelper();
		//return $html->url('/', true)."files/html/".$id.".html";
		return $id.".html";
	}


	function send_mail($to="yoji@yoshikura.com", $subject="", $mailbody="", $debug=0){
		$from = "jk@sanbangai.net";
		$name_from = "自治会";

		$bcc = "yoji@yoshikura.com";
		$name_bcc = "";

		$subject = "お餅配布の申込み";
		$name_to = "";

		$this->Qdmail->debug = $debug;
		$param = array(
		    'host' => 'b41.coreserver.jp',	//メールサーバー
		    'port' => 587,					//これはSMTPAuthの例。認証が必要ないなら　25　でＯＫ。
			'from' => $from,	//　Return-path: になります。

			'protocol' => 'SMTP_AUTH',		// 認証が必要ないなら、'SMTP'
		    'user' => $from,	//SMTPサーバーのユーザーID
		    'pass' => 'kayoken2'			//SMTPサーバーの認証パスワード
/*
			'protocol' => 'POP_BEFORE',
			'pop_host' => 'pop.yoshikura.com',
			'pop_user' => $from,
			'pop_pass' => 'kayoken2'
*/
		);

		//$this->Qdmail->smtp(true);
		$this->Qdmail->smtpServer($param);

		//$qdsmtp = & $this->Qdmail->smtpObject();
		//$qdsmtp->pop3UseFile(false);

		// --- ログを保存する
		$this->Qdmail->logLevel(1);
		$this->Qdmail->logPath( LOGS );
		$this->Qdmail->logFilename("smtp_logfile.log");

	    // --- エラーを保存する
		$this->Qdmail->errorlogLevel(1);
		$this->Qdmail->errorlogPath( LOGS );
		$this->Qdmail->errorlogFilename("smtp_errfile.log");

		// 強制的に改行を LF にする
		$this->Qdmail->lineFeed("\n");

		$this->Qdmail->to( $to, $name_to );
		$this->Qdmail->bcc( $bcc, $name_bcc );
		$this->Qdmail->subject($subject);
		$this->Qdmail->from($from, $name_from );
		$this->Qdmail->text( $mailbody );
		$return_flag = $this->Qdmail -> send();
		//debug($return_flag);

		if(!$return_flag){
			//$this->set('error_message', "メール送信エラー");
			//debug("メール送信エラー");
			return false;
		}else{
			//$this->set('error_message', "メール送信完了");
			//debug("メール送信完了");
			return true;
		}
	}



	public function array_to_string($arr){
		$s = "";
		foreach ($arr as $key => $value)
			$s .= "/".$key.":".$value;
		return $s;
	}

	function getPost($obj, $model='Shop', $post){
		if(isset($obj->params['data'][$model][$post])){
			if(!is_array($obj->params['data'][$model][$post]))
				$ret = trim($obj->params['data'][$model][$post]);
			else
				$ret = $obj->params['data'][$model][$post];
		}elseif(isset($obj->passedArgs[$post]))
			$ret = $obj->passedArgs[$post];
		else
			$ret = null;
		$obj->set($post, $ret);
		return $ret;
	}


/**
 * ファイルアップロードメソッド
 */
	public function upload_proc($up_path, $obj, &$up_file=""){
		$obj->set('error_message', "");
		$obj->set('upload_file', "");
		$obj->set('file_name', "");
		$obj->set('up_file', "");
		$obj->set('up_url', "");
		$file_name = null;
		if (!empty($obj->data) && isset($obj->data['Upload']['file_name']['tmp_name'])) {
			if( is_uploaded_file($obj->data['Upload']['file_name']['tmp_name']) ){
				if( strlen($obj->data['Upload']['file_name']['name']) == mb_strlen($obj->data['Upload']['file_name']['name']) ){
					//アップロードするファイルの場所
					$uploaddir = WWW_ROOT."files/".$up_path;	//Configure::read('upload.path');
					$uploadfile = $uploaddir.DS.basename($obj->data['Upload']['file_name']['name']);
					if(file_exists($uploadfile)){
						unlink($uploadfile);
					}
					$info = pathinfo($uploadfile);
					$file_name = $info['basename'];
					//$obj->data['Upload']['file_name']['name'] = $file_name;

					/*
					// 同じ名前のファイルがすでに存在すれば、別名に変える
					$i = 1;
					while( file_exists($uploadfile) ){
						$i++;
						$file_name = basename($info['basename'],'.'.$info['extension']).
							'_'.$i.'.'.$info['extension'];
						$uploadfile = $info['dirname'].DS.$file_name;
						$obj->log('アップロードファイル名を再作成：'.$uploadfile, LOG_DEBUG);
						$obj->data['Upload']['file_name']['name'] = $file_name;
					}
					*/

					//画像をテンポラリーの場所から、正式な置き場所へ移動
					if (move_uploaded_file($obj->data['Upload']['file_name']['tmp_name'], $uploadfile)){
						chmod($uploadfile, 0666);
						$obj->set('error_message', "ファイルのアップロードに成功しました。");
						App::import('Helper', 'Html');
						$html = new HtmlHelper();
						$up_url = $html->url('/', true)."files/".$up_path."/".$file_name;
						$up_file = WWW_ROOT."files/".$up_path."/".$file_name;

						$obj->set('up_file', $up_file);
						$obj->set('up_url', $up_url);
						$obj->set('file_name', $file_name);
					} else {
						//失敗
						$obj->set('error_message', "ファイルのアップロードに失敗しました。");
					}
				}else{
					$obj->set('error_message', "ファイル名に全角文字は使用できません。[".$obj->data['Upload']['file_name']['name']."]");
				}
			}else{
				//$obj->Upload->invalidate("file_name","ファイルをアップロードしてください。");
			}
			$obj->data = array();
		}
//debug($obj->data);
//debug($obj->data['Upload']['file_name']['tmp_name']);
//debug($file_name);
		return $file_name;
	}

	public function to_sjis($str){
		return mb_convert_encoding($str, "SJIS", "auto");
	}

	public function to_utf8($str){
		return mb_convert_encoding($str, "UTF-8", "auto");
	}

	public function sjis2utf8($data){
		return $this->mb_convert_proc($data, "SJIS, auto", "UTF-8");

//		$data2 =  $this->mb_convert_proc($data, "SJIS, auto", "UTF-8");
//		print_r($data);
//		echo "<hr>";
//		print_r($data2);
//		exit;
	}

	public function utf82sjis($data){
		return $this->mb_convert_proc($data, "UTF-8, auto", "SJIS");
	}
	
	private function mb_convert_proc($data, $from, $to){
		if(empty($data))
			return array();

		foreach($data as $key1 => $value1) {
			if(!is_array($value1)){
				if(is_null($value1))
					$data[$key1] = null;
				elseif($this->IsAllNum($value1))
					$data[$key1] = $value1;
				elseif(is_string($value1))
					$data[$key1] = mb_convert_encoding($value1, $to, $from);
				else
					$data[$key1] = $value1;
			}else{
				foreach ($value1 as $key2 => $value2) {
					//echo "Key: $key2; Value: $value2<br />\n";
					if(!is_array($value2)){
						if(is_null($value2))
							$data[$key1][$key2] = null;
						elseif($this->IsAllNum($value2))
							$data[$key1][$key2] = $value2;
						elseif(is_string($value2)){
							$data[$key1][$key2] = mb_convert_encoding($value2, $to, $from.", auto");
//echo "value2=[".$value2."]<br>";
//exit;
						}else
							$data[$key1][$key2] = $value2;
					}else{
						foreach ($value2 as $key3 => $value3) {
							//echo "Key: $key3; Value: $value3<br />\n";
							if(!is_array($value3)){
								if(is_null($value3))
									$data[$key1][$key2][$key3] = null;
								elseif($this->IsAllNum($value3))
									$data[$key1][$key2][$key3] = $value3;
								elseif(is_string($value3))
									$data[$key1][$key2][$key3] = mb_convert_encoding($value3, $to, $from);
								else
									$data[$key1][$key2][$key3] = $value3;
							}
						}
					}
				}
			}
		}
		return $data;
	}




//------------------------------------------------------------------------------
	function debug_e($str){
		if(DebugFlag)
			echo "<font color=\"#ff0000\">".$str."</font>";
	}

	function select_tag($p_array, $p_name, $p_sel_value='', $java=''){
		$m_tag = '';
 		//パラメータ値のチェック
		if(!is_array($p_array) || empty($p_array) || empty($p_name)) {
			return $m_tag;
		}
 
		$m_tag .= '<select name="' . $p_name . '" ' .$java. '>';
		$m_tag .= '<option value="" ></option>';
		foreach ($p_array as $key => $value) {
			//$m_tag .= '<option value="' . $key . '"';
			$m_tag .= '<option value="' . $value . '"';

			//選択状態にするか調べる
			//if ($key==$p_sel_value)
			if ($value == $p_sel_value)
				$m_tag .= ' selected';

			$m_tag .= '>' . $value . '</option>';
		}
		$m_tag .= '</select>';
		return $m_tag;
	}
 
	function select_tag_key($p_array, $p_name, $p_sel_value='', $java='', $size=1){
		$m_tag = '';
 		//パラメータ値のチェック
		if(!is_array($p_array) || empty($p_array) || empty($p_name)) {
			return $m_tag;
		}
		
		if($size > 1)
			$m_tag .= "<select size=\"" .$size. "\" name=\"" . $p_name . "\" "  .$java. ">";
		else
			$m_tag .= '<select name="' . $p_name . '" ' .$java. '>';
		
		
		$m_tag .= '<option value="" ></option>';
		foreach ($p_array as $key => $value) {
			$m_tag .= '<option value="' . $key . '"';
			//$m_tag .= '<option value="' . $value . '"';

			//選択状態にするか調べる
			if ($key == $p_sel_value)
			//if ($value == $p_sel_value)
				$m_tag .= ' selected';

			$m_tag .= '>' . $value . '</option>';
		}
		$m_tag .= '</select>';
		return $m_tag;
	}
 
	function radioButton($name, $value, $str1="", $str2="", $str3="", $str4="", $str5="", $str6="", $str7="", $str8=""){		//"data[Shop][lunch]", $data['Shop']['lunch'])
		if(!$str2)
			$data = array($str1);
		elseif(!$str3)
			$data = array($str1, $str2);
		elseif(!$str4)
			$data = array($str1, $str2, $str3);
		elseif(!$str5)
			$data = array($str1, $str2, $str3, $str4);
		elseif(!$str6)
			$data = array($str1, $str2, $str3, $str4, $str5);
		elseif(!$str7)
			$data = array($str1, $str2, $str3, $str4, $str5, $str6);
		elseif(!$str8)
			$data = array($str1, $str2, $str3, $str4, $str5, $str6, $str7);
		else
			$data = array($str1, $str2, $str3, $str4, $str5, $str6, $str7, $str8);

		$s = "";
		for($i=0; $i<count($data); $i++){
			$chk =  "";
			if(($i+1) == $value)
					$chk =  " checked=\"checked\"";

			$str =$data[$i];
			$s .= sprintf("<input type=\"radio\" name=\"%s\" value=\"%s\" %s />%s　\n", $name, $i+1, $chk, $str);
		}
		return $s;
	}

	function radioButton2($name, $value, $str1="", $str2="", $str3="", $str4="", $str5="", $str6="", $str7="", $str8=""){		//"data[Shop][lunch]", $data['Shop']['lunch'])
		if(!$str2)
			$data = array($str1);
		elseif(!$str3)
			$data = array($str1, $str2);
		elseif(!$str4)
			$data = array($str1, $str2, $str3);
		elseif(!$str5)
			$data = array($str1, $str2, $str3, $str4);
		elseif(!$str6)
			$data = array($str1, $str2, $str3, $str4, $str5);
		elseif(!$str7)
			$data = array($str1, $str2, $str3, $str4, $str5, $str6);
		elseif(!$str8)
			$data = array($str1, $str2, $str3, $str4, $str5, $str6, $str7);
		else
			$data = array($str1, $str2, $str3, $str4, $str5, $str6, $str7, $str8);


		$s = "";
		for($i=0; $i<count($data); $i++){
			$chk =  "";
			if(($i+1) == $value)
					$chk =  " checked=\"checked\"";

			$str =$data[$i];
			$s .= sprintf("<input type=\"radio\" name=\"%s\" value=\"%s\" %s />%s　\n", $name, $str, $chk, $str);
		}
		return $s;
	}

	function get_radio($value, $lists){
		$s = "";
		for($i=0; $i<count($lists); $i++){
			list($n, $s) = explode("_", $lists[$i]);
			if($n == $value){
				break;
			}
		}
		return $s;
	}


	function radioButton3($name, $value, $data){		//"data[Shop][lunch]", $data['Shop']['lunch'])
		$s = "";
		for($i=0; $i<count($data); $i++){
			list($id, $str) =explode("_", $data[$i]);

			$chk =  "";
			if($id == $value)
					$chk =  " checked=\"checked\"";

			//$s .= sprintf("<input type=\"radio\" name=\"%s\" value=\"%s\" %s />%s　\n", $name, $str, $chk, $str);
			//$s .= sprintf("<input type=\"radio\" name=\"%s\" value=\"%s\" %s />%s　\n", $name, $i+1, $chk, $str);
			$s .= sprintf("<input type=\"radio\" name=\"%s\" value=\"%s\" %s />%s　\n", $name, $id, $chk, $str);
		}
		return $s;
	}

	function radioButton4($name, $value, $n){
		if($n == $value)
			$chk =  " checked=\"checked\"";
		else
			$chk =  "";
		return sprintf("<input type=\"radio\" name=\"%s\" value=\"%s\" %s>", $name, $value, $chk);
	}


//*******************************************************************
	function IsKanji($d){
		$c = ord($d);
	
		if(($c >= 0x81) && ($c <=0x9F) || ($c >= 0xE0) && ($c <= 0xFC))
			return True;
		else
			return False;
	}
//*******************************************************************
	function IsKanji2($d){
		$c = ord($d);

		if(($c >= 0x40) && ($c <= 0xFC) && ($c != 0x7F))
			return True;
		else
			return False;
	}
//*******************************************************************
	function OmitNumTitle($s){
		$out = "";
		for($i=0; $i<3; $i++){
			$c = substr($s, $i, 1);
			if(!$this->IsNum($c))
				$out .= $c;
		}
		return ($out . substr($s, 3));
	}
//*******************************************************************
	function StlipNum($s){
		$out = "";
		for($i=0; $i<strlen($s); $i++){
			$c = substr($s, $i, 1);
			if($this->IsKanji($c)){
				$i++;
			}elseif($this->IsNum($c)){
				$out .= $c;
			}
		}
		return intval($out);
	}
//*******************************************************************
	function IsNum($d){
		$c = ord($d);

		if(($c >= 0x30) && ($c <= 0x39))
		//if(($c >= 48) && ($c <= 57))
			return True;
		else
			return False;
	}
//*******************************************************************
//文字列は数字か？
	function IsAllNum($buf){
	    $s = Trim($buf);
	//DEBUG("ARG=" . $s);
	
		for($i=0; $i<strlen($s); $i++){
			$c = substr($s, $i, 1);
			if($this->IsNum($c) == False){
			    return False;	
			} 
		}
	    return True;
	}
//*******************************************************************
	function ConvApost($s){
		$outs="";
		
		for($i=0; $i<strlen($s); $i++){
			$c = substr($s, $i, 1);
			if(IsKanji($c) == True){
				$i++;
				$outs .= $c. substr($s, $i, 1);
			}elseif($c == "'"){
				$outs .= "''";
			}elseif($c == "\\"){
				$outs .= "";
			}else{
				$outs .= $c;
	
			}
		}
	    return $outs;
	}
//*******************************************************************


	function conv_week($y, $m, $d){
		//曜日番号に対応する日本語の曜日リスト
		$weekjp_array = array('日', '月', '火', '水', '木', '金', '土');
		//今日の曜日
		$weekno = date('w', mktime(0, 0, 0, $m, $d, $y));
		$weekjp = $weekjp_array[$weekno];
		//echo $weekjp . '曜日です';
		return $weekjp;
	}

}
