<?php 
//	http://localhost/psp/jk/questionnaire/
//	http://localhost:81/psp/jk/questionnaire/

class JkController extends AppController {
	public $name = 'Jk';
	public $uses = array('Questionnaire');
	public $layout = 'jk';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_url = "";
	public $_path = WWW_ROOT;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/psp/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$this->set('_store_id', $this->_store_id);

		$main_title = "アンケート管理";
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'jk', 'action' => 'questionnaire'));
	}

	// http://localhost/psp/test/
	public function questionnaire(){
		$error_msg = "";
		$this->set('main_title', "アンケート管理");

		$IdNo="";
		if(isset($this->request->data['IdNo'])){
//debug($this->request->data);
			$data = $this->request->data;
			if(!$data['IdNo'])
				$data['IdNo'] = 0;
			if(!isset($data['BuildingNo']))
				$data['BuildingNo'] = 0;
			if(!isset($data['AgeGroup']))
				$data['AgeGroup'] = 0;
//debug($data);
			$conditions = array('IdNo'=>$data['IdNo']);
			$count = $this->Questionnaire->find('count', array('conditions'=>$conditions));
			if($count){
				$error_msg.="データが重複しています。<br>";
				$IdNo = $data['IdNo']+1;
			}
			if(!$data['IdNo']){
				$error_msg.="管理Noが入力されていません。<br>";
				$IdNo = $data['IdNo'];
			}
			if(!$data['BuildingNo']){
				$error_msg.="号棟が選択されていません。<br>";
				$IdNo = $data['IdNo'];
			}
			if(!$data['AgeGroup']){
				$error_msg.="年代が選択されていません。<br>";
				$IdNo = $data['IdNo'];
			}
			if(isset($data['clear'])){
				$IdNo = "";
				$error_msg="データクリヤしました。<br>";
			}
			if(!$error_msg){
				$data['id'] = NULL;
				$this->Questionnaire->save($data);
				$IdNo = $data['IdNo'] + 1;
			}
		}
		$this->set('IdNo', $IdNo);
		$this->set('error_msg', $error_msg);
	}


	public function result(){
		$error_msg = "";
		$this->set('main_title', "アンケート管理");

		$conditions = array();
		$this->paginate = array(
			'Questionnaire' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 90,
				'order' => 'IdNo', 		// desc
				'conditions' => $conditions, 
				//'group' => array('room_no', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('Questionnaire');
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}
	
	public function result_edit($id=0){
		$error_msg = "";
		$this->set('main_title', "アンケート管理");

		if(!$id){
			$this->redirect(array('controller' => 'jk', 'action' => 'result'));
		}

		$IdNo="";
		if(isset($this->request->data['IdNo'])){
//debug($this->request->data);
			$data = $this->request->data;
			if(!$data['IdNo'])
				$data['IdNo'] = 0;
			if(!isset($data['BuildingNo']))
				$data['BuildingNo'] = 0;
			if(!isset($data['AgeGroup']))
				$data['AgeGroup'] = 0;
debug($data);
			if(!$data['IdNo']){
				$error_msg.="管理Noが入力されていません。<br>";
			}
			if(!$data['BuildingNo']){
				$error_msg.="号棟が選択されていません。<br>";
			}
			if(!$data['AgeGroup']){
				$error_msg.="年代が選択されていません。<br>";
			}
			if(isset($data['clear'])){
				$error_msg="データクリヤしました。<br>";
			}
			if(!$error_msg){
				$this->Questionnaire->save($data);
			}
			$IdNo = $data['IdNo'];
		}

		$conditions = array('id'=>$id);
		$data = $this->Questionnaire->find('first', array('conditions'=>$conditions));
		$this->set('data', $data['Questionnaire']);
		$this->set('error_msg', $error_msg);
//debug($data);
	}
	
	public function statistics(){
		$error_msg = "";
		$this->set('main_title', "アンケート管理");

		$data['Total'] = $this->Questionnaire->find('count');

		/////年代
		for($i=1; $i<5; $i++){
			$conditions = array('BuildingNo'=>$i);
			$data['BuildingNo'.$i] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		}

		/////年代
		for($i=20; $i<100; $i+=10){
			$conditions = array('AgeGroup'=>$i);
			$data['AgeGroup'.$i] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		}

		//////////////////////////////////////使用機器
		$conditions = array('EquipmentPc'=>1);
		$data['EquipmentPc'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$conditions = array('EquipmentSmartphone'=>1);
		$data['EquipmentSmartphone'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$conditions = array('EquipmentMobilephone'=>1);
		$data['EquipmentMobilephone'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$conditions = array('EquipmentFixedphone'=>1);
		$data['EquipmentFixedphone'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$conditions = array('EquipmentTv'=>1);
		$data['EquipmentTv'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$conditions = array('EquipmentRadio'=>1);
		$data['EquipmentRadio'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$conditions = array('EquipmentNetTV'=>1);
		$data['EquipmentNetTV'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$conditions = array('EquipmentNetradio'=>1);
		$data['EquipmentNetradio'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		//////////////////////////////////////使用アプリ
		$conditions = array('AppliEmail'=>1);
		$data['AppliEmail'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		
		$conditions = array('AppliShortmail'=>1);
		$data['AppliShortmail'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		
		$conditions = array('AppliLine'=>1);
		$data['AppliLine'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		
		$conditions = array('AppliTwitter'=>1);
		$data['AppliTwitter'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		
		$conditions = array('AppliFacebook'=>1);
		$data['AppliFacebook'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		//////////////////////////////////////自治会LINE@
		$conditions = array('Line1 >' => 0);
		$data['Line1'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		for($i=2; $i<12; $i++){
			$conditions = array('Line'.$i => 1);
			$data['Line'.$i] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		}

		$data['Line']=array("", "登録人数", "はい", "日常に役立ちそう", "非常時に役立ちそう", 
			"特に理由はない", "いいえ", "知らない", "知っているが興味ない",
			"登録方法や操作が不明", "個人情報やセキュリティの不安", "◆BUG◆", "その他");

		$conditions = array('Line12 NOT' => "");
		$data['Line12'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$data['Line12s'] = $this->Questionnaire->find('all', array('fields'=>array('Line12'), 'conditions'=>$conditions));

		//////////////////////////////////////自治会メール配信
		$conditions = array('Maillist1 >' => 0);
		$data['Maillist1'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		for($i=2; $i<12; $i++){
			$conditions = array('Maillist'.$i => 1);
			$data['Maillist'.$i] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		}
		$data['Maillist']=array("", "登録人数", "はい", "日常に役立ちそう", "非常時に役立ちそう", 
			"特に理由はない", "いいえ", "知らない", "知っているが興味ない", "登録方法や操作が不明", 
			"個人情報やセキュリティの不安", "知っているが興味ない", "その他");
		$conditions = array('Maillist12 NOT' => "");
		$data['Maillist12'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$data['Maillist12s'] = $this->Questionnaire->find('all', array('fields'=>array('Maillist12'), 'conditions'=>$conditions));

		//////////////////////////////////////自治会情報発信手段
		for($i=1; $i<11; $i++){
			$conditions = array('Infosend'.$i => 1);
			$data['Infosend'.$i] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		}
		$data['Infosend']=array("", "LINEグループ", "LINE オープンチャット", "LINE@", "電子メール",
			"ホームページ", "Twitter", "Facebook", "テレビ", "FMラジオ", "伝言電話", "その他");
		$conditions = array('Infosend11 NOT' => "");
		$data['Infosend11'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));

		$data['Infosend11s'] = $this->Questionnaire->find('all', array('fields'=>array('Infosend11'), 'conditions'=>$conditions));

		//////////////////////////////////////ご意見
		$conditions = array('Opinion NOT' => "");
		$data['Opinion'] = $this->Questionnaire->find('count', array('conditions'=>$conditions));
		
		$data['Opinions'] = $this->Questionnaire->find('all', array('fields'=>array('Opinion'), 'conditions'=>$conditions));

//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}
	
	public function trancate(){
		$this->autoRender = false;	//View File なし
		if(strstr($_SERVER['SERVER_NAME'], "lo") or stristr($_SERVER['REMOTE_ADDR'], "106.72.195.194")){
			$sql = "TRUNCATE TABLE `questionnaires`";
			$ret = $this->Questionnaire->query($sql);
		}
		$this->redirect(array('controller' => 'jk', 'action' => 'questionnaire'));
	}
}
